USE ProductData
Go
-- Product Type Table
CREATE TABLE ProductType(
	Id INT IDENTITY(1,1) NOT NULL PRIMARY KEY,
	Name VarChar(50) UNIQUE NOT NULL,
)
GO
-- Product Category Table
CREATE TABLE ProductCategory(
	Id INT IDENTITY(1,1) NOT NULL PRIMARY KEY,
	ProductTypeId Int Not NUll Foreign Key References ProductType(Id),
	Name VarChar(50) Not Null
)
GO
-- Product Table
CREATE TABLE Product(
	Id INT IDENTITY(1,1) NOT NULL PRIMARY KEY,
	ProductCategoryId INT NOT NULL Foreign Key References ProductCategory(Id),
	Name VARCHAR(50) NOT NULL,
	[Description] VarChar(200) NOT NULL,
	Price Decimal(12,4) NOT NULL
)
GO

--Product Type Data
INSERT INTO ProductType
	SELECT 'Dairy'
INSERT INTO ProductType
	SELECT 'Meat'
INSERT INTO ProductType
	SELECT 'Bakery'
INSERT INTO ProductType
	SELECT 'Personal'
GO	
-- Product Category Data
INSERT INTO ProductCategory
	SELECT 1, 'Cheese'
INSERT INTO ProductCategory
	SELECT 1, 'Yoghurt'
INSERT INTO ProductCategory
	SELECT 1, 'Milk'
INSERT INTO ProductCategory
	SELECT 2, 'Lamb'
INSERT INTO ProductCategory
	SELECT 2, 'Beef'
INSERT INTO ProductCategory
	SELECT 2, 'Pork'
INSERT INTO ProductCategory
	SELECT 2, 'Chicken'
INSERT INTO ProductCategory
	SELECT 3, 'Bread'
INSERT INTO ProductCategory
	SELECT 3, 'Savoury'
INSERT INTO ProductCategory
	SELECT 4, 'Shaving'
GO

-- Product Category Data
INSERT INTO Product (ProductCategoryId, Name, [Description], Price)
	VALUES ( 1, 'Brie', 'Soft Cheese', 5.00)
INSERT INTO Product (ProductCategoryId, Name, [Description], Price)
	VALUES ( 1, 'Cheddar', 'Hard Aged Cheese', 3.50)
INSERT INTO Product (ProductCategoryId, Name, [Description], Price)
	VALUES ( 2, 'Yoplait', 'French Style', 0.99)
INSERT INTO Product (ProductCategoryId, Name, [Description], Price)
	VALUES ( 2, 'Yakult', 'Drinking culture', 1.25)
INSERT INTO Product (ProductCategoryId, Name, [Description], Price)
	VALUES ( 3, 'Skim', 'Low Fat Milk', 2.99)
INSERT INTO Product (ProductCategoryId, Name, [Description], Price)
	VALUES ( 4, 'Loin Chops', 'Premium Cuts', 7.99)
INSERT INTO Product (ProductCategoryId, Name, [Description], Price)
	VALUES ( 5, 'Fillet  Steak', 'Excellent Value', 14.50)
INSERT INTO Product (ProductCategoryId, Name, [Description], Price)
	VALUES ( 5, 'Pot Roast', 'Great Family Value', 9.99)
INSERT INTO Product (ProductCategoryId, Name, [Description], Price)
	VALUES ( 6, 'Sausage', 'Irish Sausages', 2.75)
INSERT INTO Product (ProductCategoryId, Name, [Description], Price)
	VALUES ( 6, 'Trotters', 'Pigs Feet in Brine', 5.50)
INSERT INTO Product (ProductCategoryId, Name, [Description], Price)
	VALUES ( 7, 'Legs', 'Great for barbeques', 3.99)
INSERT INTO Product (ProductCategoryId, Name, [Description], Price)
	VALUES ( 7, 'Breast', 'ean and Healthy', 5.95)
INSERT INTO Product (ProductCategoryId, Name, [Description], Price)
	VALUES ( 7, 'Thighs', 'deal for caseroles', 4.95)
INSERT INTO Product (ProductCategoryId, Name, [Description], Price)
	VALUES ( 8, 'Pita', 'Lebanese pockets', 1.50)
INSERT INTO Product (ProductCategoryId, Name, [Description], Price)
	VALUES ( 8, 'Tank Loaf', 'Round White ', 0.89)
INSERT INTO Product (ProductCategoryId, Name, [Description], Price)
	VALUES ( 9, 'Pies', 'all meat and vegetarian varieties', 2.50	)
INSERT INTO Product (ProductCategoryId, Name, [Description], Price)
	VALUES ( 9, 'Pasties', 'Delicious Cornish Pasties', 1.99)
INSERT INTO Product (ProductCategoryId, Name, [Description], Price)
	VALUES ( 10, 'Razors', '12 Pack', 12.35)
INSERT INTO Product (ProductCategoryId, Name, [Description], Price)
	VALUES ( 10, 'Shaving Cream', 'For a smooth shave', 6.99)
GO